package furny.ga.logger.entities;

import ga.core.individual.IFitness;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;

import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

/**
 * Database entry for an individual.
 * 
 * @since 11.08.2012
 * @author Stephan Dreyer
 */
@Entity
@Cache(usage = CacheConcurrencyStrategy.READ_ONLY)
public class IndividualEntry {

  /** The id. */
  private long id;

  /** The event. */
  private LogEvent event;

  /** The generation. */
  private int generation;

  /** The genes. */
  private Set<GeneEntry> genes = new HashSet<GeneEntry>();

  /** The fitness. */
  private Double fitness;

  /**
   * Instantiates a new individual entry.
   */
  private IndividualEntry() {
  }

  /**
   * Instantiates a new individual entry.
   * 
   * @param generation
   *          the generation
   * @param event
   *          the event
   * @param c
   *          the c
   * @param fitness
   *          the fitness
   */
  public IndividualEntry(final int generation, final LogEvent event,
      final Collection<GeneEntry> c, final Double fitness) {
    this.generation = generation;
    this.event = event;
    this.genes.addAll(c);

    if (fitness != null && fitness != IFitness.UNEVALUATED) {
      this.fitness = fitness;
    }
  }

  /**
   * Gets the id.
   * 
   * @return the id
   */
  @Id
  @GeneratedValue
  public long getId() {
    return id;
  }

  /**
   * Sets the id.
   * 
   * @param id
   *          the new id
   */
  private void setId(final long id) {
    this.id = id;
  }

  /**
   * Gets the generation.
   * 
   * @return the generation
   */
  public int getGeneration() {
    return generation;
  }

  /**
   * Sets the generation.
   * 
   * @param generation
   *          the new generation
   */
  public void setGeneration(final int generation) {
    this.generation = generation;
  }

  /**
   * Gets the event.
   * 
   * @return the event
   */
  @ManyToOne(cascade = { CascadeType.PERSIST, CascadeType.MERGE,
      CascadeType.REFRESH }, fetch = FetchType.EAGER)
  public LogEvent getEvent() {
    return event;
  }

  /**
   * Sets the event.
   * 
   * @param event
   *          the new event
   */
  public void setEvent(final LogEvent event) {
    this.event = event;
  }

  /**
   * Gets the genes.
   * 
   * @return the genes
   */
  @OneToMany(cascade = { CascadeType.PERSIST, CascadeType.MERGE,
      CascadeType.REFRESH }, fetch = FetchType.EAGER)
  public Set<GeneEntry> getGenes() {
    return genes;
  }

  /**
   * Sets the genes.
   * 
   * @param genes
   *          the new genes
   */
  public void setGenes(final Set<GeneEntry> genes) {
    this.genes = genes;
  }

  /**
   * Gets the fitness.
   * 
   * @return the fitness
   */
  public Double getFitness() {
    return fitness;
  }

  /**
   * Sets the fitness.
   * 
   * @param fitness
   *          the new fitness
   */
  public void setFitness(final Double fitness) {
    this.fitness = fitness;
  }

}
